#include <ESP8266WiFi.h>

int LED = 5;
WiFiServer server(80); //Initialize the server on Port 80
void setup() {

WiFi.mode(WIFI_AP); //Our ESP8266-12E is an AccessPoint 
WiFi.softAP("Hello_IoT", "12345678"); // Provide the (SSID, password); . 
server.begin(); // Start the HTTP Server

//Looking under the hood
Serial.begin(115200); //Start communication between the ESP8266-12E and the monitor window
IPAddress HTTPS_ServerIP= WiFi.softAPIP(); // Obtain the IP of the Server 
Serial.print("Server IP is: "); // Print the IP to the monitor window 
Serial.println(HTTPS_ServerIP);

//pinMode(LED_BUILTIN, OUTPUT); //GPIO16 is an OUTPUT pin;
pinMode(LED, OUTPUT);
//digitalWrite(LED_BUILTIN, LOW); //Initial state is ON
digitalWrite(LED, LOW);

}

void loop() 
{
 /*Check if a browser (client) has connected to the ESP8266 
  * if a browser has connected the will do something
  * else we jump out and check out again, we do this endlessly
  */
  WiFiClient client = server.available();
  if(!client){
    return;
  }
  //Looking under the hood
  Serial.println("Somebody has connected :) ");
  //Read what the browser has sent into a string class and print the request to the monito
  String request = client.readString();
  // Looking under hood
  Serial.println(request);

  // Handle the Request

  if (request.indexOf("/OFF") != -1){ 
  //digitalWrite(LED_BUILTIN, HIGH);
  digitalWrite(LED, LOW);}
  else if (request.indexOf("/ON") != -1){ 
  //digitalWrite(LED_BUILTIN, LOW);
  digitalWrite(LED, HIGH); 
}
// prepare the HTML document to respond and add buttons:

String s = "HTTP/1.1 200 OK\r\n";
s += "content-Type: text/html\r\n\r\n";
s += "<!DOCTYPE HTML>\r\n<html>\r\n";
s += "<br><input type=\"button\" name=\"b1\" value=\"Turn LED ON\" onclick=\"location.href='/ON'\">";
s += "<br><br><br>";
s += "<input type=\"button\" name=\"b1\" value=\"Turn LED OFF\" onclick=\"location.href='/OFF'\">";
s += "</html>\n";

// serve the HTML document to the browser.
client.flush(); // clear previous info in the stream
client.print(s); // send the response to the client
Serial.println("Client disconnected"); // looking under the hood
}


