#include "U8glib.h"
#include "dht.h"

#define dht_apin A1
#define backlight_pin 11

dht DHT;

U8GLIB_PCD8544 u8g(8, 4, 7, 5, 6);  // CLK=8, DIN=4, CE=7, DC=5, RST=6

const uint8_t brainy_bitmap[] PROGMEM = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xC0, 0x00, 0x60, 0x00, 0x00, 0x03, 0xF8, 0x03, 0xF8, 0x00, 0x00, 0x0F, 0xFC, 0x07, 0xFC, 0x00,
0x00, 0x0F, 0xFE, 0x0F, 0xFE, 0x00, 0x00, 0x1F, 0xFF, 0x1F, 0xFF, 0x00, 0x00, 0x1F, 0xFF, 0x1F,
0xFF, 0x00, 0x00, 0x3E, 0x0F, 0xBF, 0x0F, 0x80, 0x00, 0x3C, 0x0F, 0xBE, 0x07, 0x80, 0x00, 0x38,
0x07, 0xFC, 0x07, 0x80, 0x00, 0x38, 0x03, 0xF8, 0x43, 0xC0, 0x00, 0x78, 0x01, 0xF8, 0xE3, 0xC0,
0x00, 0x78, 0x01, 0xF0, 0xE1, 0xC0, 0x00, 0x71, 0xF1, 0xF1, 0xF1, 0xC0, 0x00, 0x71, 0xF0, 0xF1,
0xF1, 0xC0, 0x00, 0x71, 0xF1, 0xF1, 0xF1, 0xC0, 0x00, 0x70, 0x01, 0xF0, 0xE1, 0xC0, 0x00, 0x78,
0x01, 0xF0, 0xE3, 0xC0, 0x00, 0x38, 0x03, 0xF8, 0xE3, 0xC0, 0x00, 0x38, 0x07, 0xFC, 0x07, 0x80,
0x00, 0x3C, 0x07, 0xBC, 0x07, 0x80, 0x00, 0x3C, 0x07, 0xBC, 0x07, 0x80, 0x00, 0x3E, 0x0F, 0xBE,
0x0F, 0x80, 0x00, 0x1F, 0x3F, 0x1F, 0x9F, 0x80, 0x00, 0x1F, 0xFF, 0x1F, 0xFF, 0x00, 0x00, 0x1F,
0xFE, 0x0F, 0xFF, 0x00, 0x00, 0x0F, 0xFC, 0x07, 0xFC, 0x00, 0x00, 0x07, 0xF8, 0x03, 0xFC, 0x00,
0x00, 0x01, 0xF0, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0xDD, 0xBF, 0xDF, 0x00, 0x00, 0x1B,
0xFF, 0xBF, 0xDF, 0x80, 0x00, 0x1B, 0x7F, 0xB6, 0xFD, 0x80, 0x00, 0x1B, 0x7F, 0xB6, 0xFD, 0x80,
0x00, 0x3F, 0xDF, 0xB6, 0xFD, 0x80, 0x00, 0x3F, 0xDF, 0xB6, 0xFD, 0x80, 0x00, 0x3F, 0x5E, 0xFF,
0xDF, 0x80, 0x00, 0x3F, 0x7C, 0xEF, 0xDF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x52, 0x33, 0xDD, 0x9F, 0x65, 0xE8, 0x2B, 0x4F, 0x67,
0x42, 0x38, 

};

void draw(void) // draw functiom void draw(void0
{
  u8g.drawBitmapP( 35, 0, 6, 63, brainy_bitmap);  // put bitmap and in X(22) and Y(0) position
  u8g.setFont(u8g_font_profont11);  // select font you may choose the one which you want
  u8g.drawStr(0, 15, "T: ");  // put string of display at position X(0), Y(15)
  u8g.drawStr(0, 35, "H: ");
  u8g.setPrintPos(15, 15);  // set position
  u8g.print(DHT.temperature, 0);  // display temperature from DHT11
  u8g.drawStr(30, 15, "c "); 
  u8g.setPrintPos(15, 35);
  u8g.print(DHT.humidity, 0);  // display humidity from DHT11
  u8g.drawStr(30, 35, "% ");
}

void setup(void) {
  analogWrite(backlight_pin, 50);  /* Set the Backlight intensity */
}

void loop(void) {
  DHT.read11(dht_apin);  // Read apin on DHT11

  u8g.firstPage();  
  do {
    draw();
  } while( u8g.nextPage() );
  
  delay(5000);  // Delay of 5sec before accessing DHT11 (min - 2sec)
}
