/* Arduino Tutorial: Learn how to use an LCD 16x2 screen
   More info: http://www.ardumotive.com/how-to-use-an-lcd-dislpay-en.html  */

//Include LCD library
#include <LiquidCrystal.h>
#include "DHT.h"

#define DHTPIN 6
#define DHTTYPE DHT22


// initialize the library with the numbers of the interface pins
LiquidCrystal lcd(12, 11, 5, 4, 3, 2);
DHT dht(DHTPIN, DHTTYPE);

void setup() {
  // set up the LCD's number of columns and rows: 
  lcd.begin(16, 2);
  dht.begin();
  // Print a message to the LCD.
  lcd.setCursor(0,0);
  lcd.print("Faranux");
  lcd.setCursor(0,1);
  lcd.print("Electronics");
  delay(5000);
}

void loop() {
  // set the cursor to column 0, line 1
  // (note: line 1 is the second row, since counting begins with 0):
  int h = dht.readHumidity();
  int t = dht.readTemperature();
  float f = dht.readTemperature(true);
  
  if (isnan(h) || isnan(t) || isnan(f)) {
    Serial.println("Failed to read from DHT sensor!");
    return;
  }

  float hif = dht.computeHeatIndex(f, h);
  float hic = dht.computeHeatIndex(t, h, false);
  
  lcd.clear();
  lcd.setCursor(0, 0);
  //Print a message to second line of LCD
  lcd.print("Temperature:");
  lcd.setCursor(12,0);
  lcd.print(t);
  lcd.setCursor(14,0);
  lcd.print(" C");
  lcd.setCursor(0, 1);
  lcd.print("Humidity   :");
  lcd.setCursor(12,1);
  lcd.print(h);
  lcd.setCursor(15,1);
  lcd.print("%");
  //lcd.setCursor(13, 0);
  //lcd.print("heat");
  delay(1000);
}
